// Copyright (c) 2001 World Wide Web Consortium,
// (Massachusetts Institute of Technology, Institut National de
// Recherche en Informatique et en Automatique, Keio University). All
// Rights Reserved. This program is distributed under the W3C's Software
// Intellectual Property License. This program is distributed in the
// hope that it will be useful, but WITHOUT ANY WARRANTY; without even
// the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE.
// See W3C License http://www.w3.org/Consortium/Legal/ for more details.
//
// $Id: demo.js,v 1.5 2001/08/30 00:01:30 plehegar Exp $

// This is a demo of DOM Level 2

var XHTML_NS = "http://www.w3.org/1999/xhtml";

// Redisplay the elements following the target node on the screen
// and set the event handlers appropriatly
function addChildsOnScreen(e) {
    if (e.button == 0) { // if left button
	// get the target node, then its next sibling
	var node = e.currentTarget.nextSibling;

	while (node != null) {
	    if (node.nodeType == 1) {
		// assume all are block-level
		node.style
		    .setProperty("display", "block", "");
	    }
	    node = node.nextSibling;
	}
	// remove the "+ " added by removeChildsFromScreen
	e.currentTarget.removeChild(e.currentTarget.firstChild);
	 
	// remove the activation of this function
	e.currentTarget
	    .removeEventListener("mousedown", addChildsOnScreen, false);
	// add the activation of removeChildsFromScreen
	e.currentTarget
	    .addEventListener("mousedown", removeChildsFromScreen, false);
    }
}

// Remove the elements following the target node from the screen
// and set the event handlers appropriatly
function removeChildsFromScreen(e) {
    
    if (e.button == 0) { // if left button	
	// get the target node, then its next sibling
	var node = e.currentTarget.nextSibling;
	while (node != null) {
	    if (node.nodeType == 1) {
		node.style
		    .setProperty("display", "none", "");
	    }
	    node = node.nextSibling;
	}
	// add the "+ " for the UI feedback
	e.currentTarget.insertBefore(document.createTextNode('+ '),
				     e.currentTarget.firstChild);
	
	// remove the activation of this function
	e.currentTarget
	    .removeEventListener("mousedown", removeChildsFromScreen, false);
	// add the activation of addChildsOnScreen
	e.currentTarget
	    .addEventListener("mousedown", addChildsOnScreen, false);
    }
}

function getContent(node) {
    var _result = "";
    if (node == null) {
	return _result;
    }
    var childrens = node.childNodes;
    var i = 0;
    while (i < childrens.length) {
	var child = childrens.item(i);
	switch (child.nodeType) {
	case 1: // ELEMENT_NODE
	case 2: // ATTRIBUTE_NODE
	case 5: // ENTITY_REFERENCE_NODE
	    _result += getContent(child);
	    break;
	case 3: // TEXT_NODE
	case 4: // CDATA_SECTION_NODE
	case 7: // PROCESSING_INSTRUCTION_NODE
	    _result += child.data;
	    break;
	case 6: // ENTITY_NODE
	case 8: // COMMENT_NODE
	case 9: // DOCUMENT_NODE
	case 10: // DOCUMENT_TYPE_NODE
	case 11: // DOCUMENT_FRAGMENT_NODE
	case 12: // NOTATION_NODE
	    // skip
	    break;
	}
	i ++;
    }
    return _result;
}

function init() {

    if (document.implementation
	&& document.implementation.hasFeature
	&& document.implementation.hasFeature("XML", "2.0")) {
	// generate the table of contents

	var olist = document.createElementNS(XHTML_NS, "ol");
	
	var h2s = document.getElementsByTagName("h2");
	var i = 0;
	var li, a;

	while (i < h2s.length) {
	    var h2 = h2s.item(i);
	    
	    // add an id attribute if missing
	    if (h2.getAttribute("id") == "") {
		h2.setAttribute("id", "generated" + i );
	    }
	    
	    li = document.createElementNS(XHTML_NS, "li");
	    a = document.createElementNS(XHTML_NS, "a");
	    a.setAttribute("href", "#" + h2.getAttribute("id"));
	    a.appendChild(document.createTextNode(getContent(h2)));
	    li.appendChild(a);
	    olist.appendChild(li);
	    i ++;
	}
	
	var firstDiv = document.getElementsByTagName("div").item(0);
	var body = firstDiv.parentNode;
	var newDiv = document.createElementNS(XHTML_NS, "div");
	var title = document.createElementNS(XHTML_NS, "h2");
	title.appendChild(document.createTextNode("Table of contents"));
	newDiv.appendChild(title);
	newDiv.appendChild(olist);
	body.insertBefore(newDiv, firstDiv);
    }	

    if (document.implementation
	&& document.implementation.hasFeature
	&& document.implementation.hasFeature("CSS", "2.0")
	&& document.implementation.hasFeature("MouseEvents", "2.0")) {
	
	// using directly the tag name
	// other solution could be:
	// document.getElementsByTagNameNS(XHTML_NS, "h2");
	var h2s = document.getElementsByTagName("h2");
	var i = 0;
	
	// add the event handler on each h2
	while (i < h2s.length) {
	    var h2 = h2s.item(i);
	    h2.addEventListener("mousedown", 
				removeChildsFromScreen, false);
	    h2.style.cursor = "pointer";
	    i ++;
	}      
    }
}
